require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(true);

MakeDialog
{
    CDPanelFail
    {
        name="panelfail",
        x = 0,
        y = 0,
        w = 800,
        h = 600,
        
        enter_curve = "config/curves/fx_start.xml",
        exit_curve = "config/curves/fx_end.xml",
        
        Bitmap
        {
            x=kCenter,y=kCenter-1000,
            w=800,h=600,
            name="panel",
            alpha = 1,        
            Bitmap
            {
                name="infopanel",
                image="ui/levelover/levelover",
                x=kCenter,
                y=kCenter,
                
		SetStyle(CreateTextStyle(FontGame, 30, DarkRedColor)),
		CreateText(kCenter-85,kCenter-230,"caption_fail",0,0),

                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                CreateTextLeftAlign(kCenter+65, kCenter+30, "#"..GetString("tables_served",GetCustomersServedStr()), 0, 0),
                
                CreateTextLeftAlign(kCenter+65, kCenter+50, "#"..GetString("tables_lost",GetCustomersLostStr()), 0, 0),
                

                               
                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {-- text for level loss
                    x=100,
                    y=125,
                    w=250,--kMax-80,
                    h=kMax,
                    flags=kHAlignLeft+kVAlignTop,
                    label=GetString("story_fail",GetCurrLevelNumStr()),
                },
                
                SetStyle(CreateTextStyle(FontGame, 26, DarkRedColor)),
                Text
                {-- text "score:"
                    x=kCenter+65,y=kCenter+90,
                    flags=kHAlignLeft+kVAlignCenter,
                    label="levelscore",
                },
                
                SetStyle(CreateTextStyle(FontGame, 26, DarkRedColor)),
                Text
                {-- score value
                    x=kCenter+130,y=kCenter+90,
                    flags=kHAlignLeft+kVAlignCenter,
                    label=GetLevelScore(),
                },

                SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
                Text
                {-- text "Total:"
                    x=kCenter+65,y=kCenter+120,
                    flags=kHAlignLeft+kVAlignCenter,
                    label="totalscore",
                },
                
                SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
                Text
                {-- total score value
                    x=kCenter+130,y=kCenter+120,
                    flags=kHAlignLeft+kVAlignCenter,
                    label=GetHighScore(),
                },

                SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter + 95,
                    y=kCenter + 185,
                    name="tryagain",
                    default = true,
                    command=
                        function()
                            HideFailPanel();
                        end,
				    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
				    CreateText(2,2,"tryagain", 0, 0),
				    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
				    CreateText(0,0,"tryagain", 0, 0),
                },
                
                SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter - 55,
                    y=kCenter + 185,
                    name="quit",
                    default = true,
                    command=
                        function()
                            result = DisplayDialog {
                                "scripts/yesno.lua",
                                body ="quitmenuconfirm",
                                title = "quitmenutitle"
                            };
                            if (result=='yes') then
                                CloseWindow();
                                SetPauseMenuCanShow(false);
                                SetConfirmExitCanShow(true);
                                SetGamePause(false);
                                ToMainMenu();
                            end
                        end,
				    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
				    CreateText(2,2,"quit", 0, 0),
				    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
				    CreateText(0,0,"quit", 0, 0),
                },
            },
            
            Bitmap
            {-- picture with upset flo
                name="fail",
                image="ui/levelover/flo_lose",
                x=kCenter-200,
                y=kCenter+24,
            },
        },
    },
}
